###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_bof_vuln_jun09.nasl 3101 2009-06-24 10:22:29Z jun $
#
# Google Chrome Browser Kernel Buffer Overflow Vulnerability - Jun09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900380);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2121");
  script_bugtraq_id(35462);
  script_name("Google Chrome Web Script Execution Vulnerabilites - Jun09");
  desc = "

  Overview: This host has Google Chrome installed and is prone to buffer
  overflow vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error when handling unspecified HTTP responses.
  This can be exploited to cause a buffer overflow via a specially crafted HTTP
  response received from an HTTP server.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code, and
  can cause Denial of Service or compromise a user's system.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version prior to 2.0.172.33 on Windows.

  Fix: Upgrade to version 2.0.172.33 or later
  http://www.google.com/chrome

  References:
  http://secunia.com/advisories/35548
  http://code.google.com/p/chromium/issues/detail?id=14508
  http://googlechromereleases.blogspot.com/2009/06/stable-beta-update-security-fix.html

  CVSS Score Report:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

# Check for Google Chrome version < 2.0.172.33
if(version_is_less(version:chromeVer, test_version:"2.0.172.33")){
  security_hole(0);
}
