###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ghostscript_detect_win.nasl 1699 2009-04-21 13:47:29Z apr $
#
# Ghostscript Version Detection (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900539);
  script_version("$Revision: 1.0 $");
  script_name("Ghostscript Version Detection (Win)");
  desc = "
  Overview: This script detects the installed version of Ghostscript and
  sets the reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Ghostscript");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\GPL Ghostscript")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  ghostName = registry_get_sz(key:key + item, item:"DisplayName");
  if("Ghostscript" >< ghostName)
  {
    ghostVer = eregmatch(pattern:"Ghostscript ([0-9.]+)", string:ghostName);
    if(ghostVer[1] != NULL){
      set_kb_item(name:"Ghostscript/Win/Ver", value:ghostVer[1]);
    }
    exit(0);
  }
}
