###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_geccbblite_detect.nasl 7391 2010-02-24 16:25:36Z feb $
#
# geccBBlite Version Detection
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900746);
  script_version("$Revision: 6841 $: 1.0");
  script_name("geccBBlite Version Detection");
  desc = "
  Overview: This script finds the running geccBBlite version and saves
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of geccBBlite in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

gbbPort = get_http_port(default:80);
if(!gbbPort){
  exit(0);
}

foreach path (make_list("/", "/geccBBlite", "/geccBB", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:gbbPort);
  rcvRes = http_send_recv(port:gbbPort, data:sndReq);
  if("geccBB - il bordo dei bollettini" >< rcvRes)
  {
    gcbbVer = eregmatch(pattern:"geccBBlite ([0-9.]+)", string:rcvRes);
    if(isnull(gcbbVer)){
      gcbbVer = eregmatch(pattern:"geccBB - il bordo dei bollettini - v. ([0-9.]+)",
                          string:rcvRes);
    }
    if(gcbbVer[1] != NULL){
     set_kb_item(name:"www/" + gbbPort + "/geccBBlite", value:gcbbVer[1] + " under " +path);
    }
  }
}
