###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_fsecure_prdts_sec_bypass_vuln_lin.nasl 2474 2009-05-27 21:33:24Z may $
#
# F-Secure Products Security Bypass Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900363);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1782");
  script_bugtraq_id(34849);
  script_name("F-Secure Products Security Bypass Vulnerability (Linux)");
  desc = "

  Overview: This host is installed with F-Secure Product and is prone to
  Security Bypass vulnerability.

  Vulnerability Insight:
  Error in the file parsing engine can be exploited to bypass the anti-virus
  scanning functionality via a specially crafted ZIP or RAR file.

  Impact:
  Successful attacks can allow attackers to bypass scanning detection and
  possibly launch further attacks on the vulnerable system.

  Impact Level: Application

  Affected Software/OS:
  F-Secure Linux Security prior to 7.03 build 81803
  F-Secure Internet Gatekeeper for Linux prior to 3.02 build 1221
  F-Secure Anti-Virus Linux Client and Server Security 5.54 and prior

  Fix: Apply patch or Upgrade to Higher version
  http://www.f-secure.com/en_EMEA/downloads
  http://www.f-secure.com/en_EMEA/support/security-advisory/fsc-2009-1.html

  References:
  http://secunia.com/advisories/35008
  http://xforce.iss.net/xforce/xfdb/50346
  http://www.vupen.com/english/advisories/2009/1262

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of F-Secure Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Malware");
  script_dependencies("gb_fsecure_prdts_detect_lin.nasl");
  script_require_keys("F-Sec/AV/LnxSec/Ver", "F-Sec/AV/LnxClntSec/Ver");
  script_require_keys("F-Sec/AV/LnxSerSec/Ver", "F-Sec/IntGatekeeper/Lnx/Ver");
  exit(0);
}


include("version_func.inc");

# Linux Security
fsavVer = get_kb_item("F-Sec/AV/LnxSec/Ver");
if(fsavVer != NULL)
{
  # Grep for version < 7.03 build 81803
  if(version_is_less(version:fsavVer, test_version:"7.03.81803"))
  {
    security_hole(0);
    exit(0);
  }
}

# Linux Client Security
fslcsVer = get_kb_item("F-Sec/AV/LnxClntSec/Ver");
if(fslcsVer != NULL)
{
  # Grep for version <= 5.54
  if(version_is_less_equal(version:fslcsVer, test_version:"5.54"))
  {
    security_hole(0);
    exit(0);
  }
}

# Linux Server Security
fslssVer = get_kb_item("F-Sec/AV/LnxSerSec/Ver");
if(fslssVer != NULL)
{
  # Grep for version <= 5.54
  if(version_is_less_equal(version:fslssVer, test_version:"5.54"))
  {
    security_hole(0);
    exit(0);
  }
}

# Internet Gatekeeper
fsigkVer = get_kb_item("F-Sec/IntGatekeeper/Lnx/Ver");
if(fsigkVer != NULL)
{
  # Grep for version < 3.02 build 1221
  if(version_is_less(version:fsigkVer, test_version:"3.02.1221")){
    security_hole(0);
  }
}
