###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_freesshd_pre_auth_dos_vuln.nasl 5058 2009-09-30 15:01:39Z sep $
#
# freeSSHd Pre-Authentication Error Remote DoS Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900960);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3340");
  script_bugtraq_id(36235);
  script_name("freeSSHd Pre-Authentication Error Remote DoS Vulnerability");
  desc = "
  Overview: This host has freeSSHd installed and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an unspecified pre-authentication error.

  Impact:
  Successful attack could allow attackers to crash application to cause
  denial of service.

  Impact Level: Application

  Affected Software/OS:
  freeSSHd version 1.2.4 and prior.

  Fix: No solution or patch is available as on 30th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.freesshd.com/

  References:
  http://intevydis.com/vd-list.shtml
  http://www.intevydis.com/blog/?p=57
  http://secunia.com/advisories/36506
  http://securitytracker.com/alerts/2009/Sep/1022811.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of freeSSHd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_freesshd_detect.nasl");
  script_require_keys("freeSSHd/Ver");
  script_require_ports("Services/ssh", 22);
  exit(0);
}


include("version_func.inc");

sshdVer = get_kb_item("freeSSHd/Ver");
if(sshdVer)
{
  # Grep for freeSSHd version 1.2.4 and prior
  if(version_is_less_equal(version:sshdVer, test_version:"1.2.4")){
    security_warning(sshdPort);
  }
}
