###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_freesshd_detect.nasl 5058 2009-09-30 13:14:28Z sep $
#
# freeSSHd Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900959);
  script_version("$Revision: 1.0 $");
  script_name("freeSSHd Version Detection");
  desc = "
  Overview: This script detects the installed version of freeSSHd and sets
  the reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of freeSSHd");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
     exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  sshdName = registry_get_sz(key:key + item, item:"DisplayName");

  if("freeSSHd" >< sshdName)
  {
    sshdVer = eregmatch(pattern:"freeSSHd ([0-9.]+)", string:sshdName);

    if(!isnull(sshdVer[1])){
      set_kb_item(name:"freeSSHd/Ver", value:sshdVer[1]);
    }
  }
}
