###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_foxit_wac_server_detect.nasl 4255 2009-08-27 12:25:24Z aug $
#
# Foxit WAC Server Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900923);
  script_version("Revision: 1.0");
  script_name("Foxit WAC Server Version Detection");
  desc = "
  Overview : This script finds the version of Foxit WAC Server and
  saves the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_summary("Set version of Foxit WAC Server in KB");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports("Services/ssh", 22, "Services/telnet", 23);
  exit(0);
}


include("ssh_func.inc");
include("telnet_func.inc");

sshdPort = get_kb_item("Services/ssh");
if(!sshdPort){
  sshdPort = 22;
}

telnetPort = get_kb_item("Services/telnet");
if(!telnetPort){
  telnetPort = 23;
}

foreach port (make_list(sshdPort, telnetPort))
{
  banner = get_kb_item("SSH/banner/" + port);
  if("WAC" >!< banner){
    banner = get_kb_item("telnet/banner/" + port);
  }

  wacserVer = eregmatch(pattern:"Server[-| ](([0-9.]+).?(([a-zA-Z]+[ 0-9]+))?)",
                       string: banner);
  if(wacserVer[1] != NULL)
  {
    wacVer = ereg_replace(pattern:" ", string:wacserVer[1], replace:".");
    if(wacVer != NULL){
      set_kb_item(name:"Foxit-WAC-Server/Ver", value:wacVer);
    }
  }
}
