###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_foxit_wac_server_bof_vuln.nasl 4255 2009-08-27 13:59:29Z aug $
#
# Foxit WAC Server Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900924);
  script_version("$ Revision: 1.0 $");
  script_cve_id("CVE-2008-7031");
  script_bugtraq_id(27873);
  script_name("Foxit WAC Server Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is running Foxit WAC Server and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  A heap-based buffer-overflow occurs in the 'wacsvr.exe' while processing
  overly long packets sent to SSH/Telnet ports.

  Impact:
  Successful exploitation will let the attackers execute arbitrary code
  and crash the application to cause denial of service.

  Affected Software/OS:
  Foxit WAC Server 2.0 Build 3503 and prior on Windows.

  Fix:
  No solution or patch is available as on 27th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.foxitsoftware.com/wac/server_intro.php

  References:
  http://secunia.com/advisories/28272/
  http://aluigi.org/adv/wachof-adv.txt
  http://xforce.iss.net/xforce/xfdb/40608

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Foxit WAC Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_foxit_wac_server_detect.nasl");
  script_require_keys("Foxit-WAC-Server/Ver");
  exit(0);
}


include("version_func.inc");

wacPort = 22;
if(!get_port_state(wacPort))
{
  wacPort = 23;
  if(!get_port_state(wacPort)){
    exit(0);
  }
}

wacVer = get_kb_item("Foxit-WAC-Server/Ver");
if(!wacVer){
  exit(0);
}

# Grep for version 2.0.3503 and prior.
if(version_is_less_equal(version:wacVer, test_version:"2.0.Build.3503")){
  security_hole(wacPort);
}
