##############################################################################
#
#  FlexCell Grid Control ActiveX Arbitrary File Overwrite Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/26
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0533
#  --------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
##############################################################################

if(description)
{
  script_id(900406);
  script_bugtraq_id(32443);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_category(ACT_GATHER_INFO);
  script_family("General");
  script_name("FlexCell Grid Control ActiveX Arbitrary File Overwrite Vulnerability");
  script_summary("Check for vulnerable version of FlexCell");
  desc = "
  Overview: This host is installed with FlexCell Grid Control ActiveX and is
  prone to arbitrary File Overwrite vulnerability.
  
  Vulnerability Insight:
  The vulnerability is caused due to an error in the 'httpDownloadFile' method
  in the 'FlexCell.ocx' component file.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes.

  Impact Level: System/Application

  Affected Software/OS:
  FlexCell Grid Control ActiveX 5.7.1 and prior on all Windows Platform.
  
  Workaround:
  Set the killbit for the affected ActiveX control.
  http://support.microsoft.com/kb/240797
  
  References:
  http://www.grid2000.com
  http://secunia.com/advisories/32829

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:C/I:C/A:N)
    CVSS Temporal Score : 7.1
  Risk factor: High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
entries = registry_enum_keys(key:key);
foreach item (entries)
{
  flexcellName = registry_get_sz(key:key + item, item:"DisplayName");
  if("FlexCell Grid Control" >< flexcellName)
  {
    # Grep or versions 5.7.1 and prior.
    if(egrep(pattern:"^([0-4]\..*|5\.[0-6](\..*)?|5\.7(\.[01])?)$",
             string:registry_get_sz(key:key + item, item:"DisplayVersion"))){
      security_warning(0);
    }
  }
}
