###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_mult_vuln_feb10_win.nasl 7334 2010-02-22 14:33:29 feb $
#
# Firefox Multiple Vulnerabilities Feb-10 (Linux)
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900743);
  script_version("$Revision: 6804 $: 1.0");
  script_cve_id("CVE-2010-0648", "CVE-2010-0654");
  script_name("Firefox Multiple Vulnerabilities Feb-10 (Linux)");
  desc = "
  Overview: The host is installed with Firefox Browser and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - The malformed stylesheet document and cross-origin loading of CSS
    stylesheets even when the stylesheet download has an incorrect MIME type.
  - IFRAME element allows placing the site&qts URL in the HREF attribute of a
    stylesheet 'LINK' element, and then reading the 'document.styleSheets[0].href'
    property value.

  Impact:
  Successful exploitation allows attackers to obtain sensitive information via
  a crafted document.

  Impact Level: Application.

  Affected Software/OS:
  Firefox version prior to 3.6 on Linux.

  Fix: Upgrade to Firefox version 3.6,
  For updates refer, http://www.mozilla.com/en-US/firefox/all.html

  References:
  http://code.google.com/p/chromium/issues/detail?id=9877
  http://code.google.com/p/chromium/issues/detail?id=32309

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("General");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Firefox Check
ffVer = get_kb_item("Firefox/Linux/Ver");
if(isnull(ffVer)){
  exit(0);
}

# Check for Firefox version less than 3.6
if(version_is_less(version:ffVer, test_version:"3.6")){
  security_warning(0);
}
