###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_insecure_saving_download_file.nasl 4913 2009-09-23 15:02:29Z sep $
#
# Insecure Saving Of Downloadable File In Mozilla Firefox (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900869);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-3274");
  script_name("Insecure Saving Of Downloadable File In Mozilla Firefox (Linux)");
  desc = "
  Overview: This host is installed with Mozilla Firefox and is prone to insecure
  saving of downloadable file.

  Vulnerability Insight:
  This security issue is caused due to the browser using a fixed path from the
  /tmp directory when a user opens a file downloaded for opening from the
  'Downloads' window. This can be exploited to trick a user into opening a file
  with potentially malicious content by placing it in the /tmp directory before
  the download takes place.

  Impact:
  Local attackers may leverage this issue by replacing an arbitrary downloaded
  file by placing a file in a /tmp location before the download occurs.

  Impact Level: Application

  Affected Software/OS:
  Mozilla Firefox version 2.x, 3.x on Linux.

  Fix: No solution or patch is available as on 23rd September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.mozilla.com/en-US/firefox/

  References:
  http://secunia.com/advisories/36649
  http://jbrownsec.blogspot.com/2009/09/vamos-updates.html
  http://securitytube.net/Zero-Day-Demos-%28Firefox-Vulnerability-Discovered%29-video.aspx

  CVSS Score:
    CVSS Base Score     : 4.4 (AV:L/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Mozilla Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_firefox_detect_lin.nasl");
  script_require_keys("Firefox/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Linux/Ver");

# Check for Mozilla Firefox version 2.x or 3.x
if(ffVer =~ "^(2|3)\..*"){
  security_warning(0);
}
