##############################################################################
#
#  Visagesoft eXPert PDF Viewer ActiveX Control File Overwrite Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/06
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0447
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900174);
  script_bugtraq_id(31984);
  script_cve_id("CVE-2008-4919");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("Remote file access");
  script_name("Visagesoft eXPert PDF Viewer ActiveX Control File Overwrite Vulnerability");
  script_summary("Check for vulnerable version of eXPert PDF Viewer ActiveX");
  desc = "

  Overview: The host is installed with eXPert PDF Viewer ActiveX and is prone
  to ActiveX Control based file overwrite vulnerability.

  Vulnerability Insight:
  The flaw is caused due to insecure method, 'savePageAsBitmap()' in VSPDFViewerX.ocx
  ActiveX Control. This can be exploited to corrupt arbitrary files on the local
  system via arguments passed to the affected method.

  Impact:
  Successful exploitation will allow to overwrite arbitrary files.

  Impact Level: Application

  Affected Software/OS:
  Visagesoft eXPert PDF Viewer ActiveX Control versions 3.0.990.0 and prior
 
  Fix: Set the kill-bit for the CLSID {BDF3E9D2-5F7A-4F4A-A914-7498C862EA6A}.
  No solution/patch is available as on 06rd November, 2008.

  References:
  http://milw0rm.com/exploits/6875
  http://secunia.com/advisories/32426

  CVSS Score:
    CVSS Base Score     : 9.4 (AV:N/AC:L/Au:NR/C:N/I:C/A:C)
    CVSS Temporal Score : 8.5
  Risk factor : Critical";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}

include("smb_nt.inc");
include("secpod_smb_func.inc");


if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
enumKeys = registry_enum_keys(key);

if(!enumKeys){
  exit(0);
} 

foreach entry (enumKeys)
{
  if("eXPert PDF ViewerX" ><
     registry_get_sz(key: key + entry, item:"DisplayName"))
  {
    # Grep for version 3.0.990.0 and prior
    if(egrep(pattern:"^([0-2](\..*)?|3\.(0(\.[0-8]?[0-9]?[0-9](\..*)?|\.9" +
                     "[0-8][0-9](\..*)?|\.990(\.0)?)?))$",
             string:registry_get_sz(key: key + entry, item:"DisplayVersion")))
    {
      # Check for Kill-Bit set for ActiveX control
      clsid = "{BDF3E9D2-5F7A-4F4A-A914-7498C862EA6A}";
      regKey = "SOFTWARE\Classes\CLSID\" + clsid;
      if(registry_key_exists(key:regKey))
      {
        activeKey = "SOFTWARE\Microsoft\Internet Explorer\" +
                    "ActiveX Compatibility\" + clsid;
        killBit = registry_get_dword(key:activeKey, item:"Compatibility Flags");
        if(killBit && (int(killBit) == 1024)){
          exit(0);
        }
        security_warning(0);
      }
    }
    exit(0);
  }
}
