###############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_expert_pdf_editorx_activex_vuln.nasl 1068 2009-03-24 19:50:24Z mar $
#
# Expert PDF EditorX ActiveX File Overwrite Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900481);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6496");
  script_bugtraq_id(32664);
  script_name("Expert PDF EditorX ActiveX File Overwrite Vulnerability");
  desc = "

  Overview: This host is installed with Expert PDF EditorX and is
  prone to ActiveX file overwrite vulnerability.

  Vulnerability Insight:
  This flaw is due to an ActiveX control in Expert PDF EditorX file
  'VSPDFEditorX.ocx' providing insecure 'extractPagesToFile' method.

  Impact:
  Successful exploitation will let the attacker corrupt or overwrite
  arbitrary files on the user's system.

  Impact Level: System/Application

  Affected Software/OS:
  Expert PDF EditorX 'VSPDFEditorX.ocx' version 1.0.1910.0 and prior.

  Workaround:
  Set the Killbit for the vulnerable CLSID {89F968A1-DBAC-4807-9B3C-405A55E4A279}
  http://support.microsoft.com/kb/240797

  Fix: No solution or patch is available as on 26th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.visagesoft.com/products/pdfeditorx

  References:
  http://secunia.com/advisories/32990
  http://www.milw0rm.com/exploits/7358
  http://xforce.iss.net/xforce/xfdb/47166

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:N/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the 'VSPDFEditorX.ocx' Version and Killbit");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  editorx = registry_get_sz(key:key + item, item:"DisplayName");
  if("eXPert PDF EditorX" >< editorx)
  {
    ocxVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    break;
  }
}

if(ocxVer != NULL)
{
  # Grep for VSPDFEditorX.ocx version 1.0.1910.0 and prior
  if(version_is_less_equal(version:ocxVer, test_version:"1.0.1910.0"))
  {
    if(is_killbit_set(clsid:"{89F968A1-DBAC-4807-9B3C-405A55E4A279}") == 0){
      security_hole(0);
    }
  }
}
