###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_devecot_detect.nasl 4844 2009-09-22 15:21:24Z sep $
#
# Dovecot Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901025);
  script_version("Revision: 1.0 ");
  script_name("Dovecot Version Detection");
  desc = "
  Overview: This script detects the installed version of Dovecot and sets the
  result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of Dovecot");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_bin(prog_name:"dovecot", sock:sock);
foreach dovecotbin (paths)
{
  dovecotVer = get_bin_version(full_prog_name:chomp(dovecotbin), sock:sock,
                        version_argv:"--version", ver_pattern:"([0-9.]+)");
  if(dovecotVer[1] != NULL){
    set_kb_item(name:"Dovecot/Ver", value:dovecotVer[1]);
  }
}
ssh_close_connection();
