###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_cyrus_sasllib_detect.nasl 2347 2009-05-27 15:21:24Z may $
#
# Cyrus SASL Library Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900659);
  script_version("Revision: 1.0 ");
  script_name("Cyrus SASL Library Version Detection");
  desc = "

  Overview: This script detects the installed version of Cyrus SASL Library and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of Cyrus SASL Library");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_bin(prog_name:"sasldblistusers2", sock:sock);
foreach saslbin (paths)
{
  saslVer = get_bin_version(full_prog_name:chomp(saslbin), sock:sock,
                             version_argv:"-v", ver_pattern:"version ([0-9.]+)");
 if(saslVer[1] != NULL)
  {
    set_kb_item(name:"Cyrus/SASL/Ver", value:saslVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
