###############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_bopup_server_bof_vuln.nasl 3177 2009-07-04 15:05:27Z jul $
#
# Bopup Communication Server Remote Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900687);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2227");
  script_name("Bopup Communication Server Remote Buffer Overflow Vulnerability");
  desc = "

  Overview:
  This host has Bopup Communication Server installed and is prone to Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to a boundary error that can be exploited to cause
  a stack-based buffer overflow via a specially crafted TCP packet sent to
  port 19810.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code with
  SYSTEM privileges or can crash an affected server.

  Impact Level: Application/System.

  Affected Software/OS:
  Bopup Communications Server version 3.2.26.5460 and prior

  Fix: No solution or patch is available as on 04th July 2009. Information
  regarding this issue will be update once the solution details are available.
  For updates refer, http://www.blabsoft.com/products/server

  References:
  http://www.milw0rm.com/exploits/9002
  http://secunia.com/advisories/product/25643/
  http://www.vupen.com/english/advisories/2009/1645

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Checks for the Version of Bopup Communication Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_bopup_server_detect.nasl");
  script_require_keys("Bopup/Server/Ver");
  exit(0);
}


include("version_func.inc");

bopupPort = 19810;
if(!get_port_state(bopupPort)){
  exit(0);
}

bopupVer = get_kb_item("Bopup/Server/Ver");
if(bopupVer != NULL)
{
  if(version_is_less_equal(version:bopupVer, test_version:"3.2.26.5460")){
    security_hole(bopupPort);
  }
}
