###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_bitweaver_dir_trav_n_code_inj_vuln.nasl 2385 2009-05-20 15:05:29Z may $
#
# Bitweaver Directory Traversal And Code Injection Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900356);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2009-1677", "CVE-2009-1678");
  script_bugtraq_id(34910);
  script_name("Bitweaver Directory Traversal And Code Injection Vulnerabilities");
  desc = "

  Overview:
  This host is running Bitweaver, which is prone to directory traversal and
  code injection vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are due to improper handling of user supplied input in saveFeed
  function in rss/feedcreator.class.php file and it can cause following attacks.
  - PHP code injection via placing PHP sequences into the account 'display name'
    setting for authenticated users or in the HTTP Host header for remote users
    by sending a request to boards/boards_rss.php.
  - Directory traversal allow remote user to create or overwrite arbitrary file
    via a .. (dot dot) in the version parameter to boards/boards_rss.php.

  Impact:
  Successful exploitation will let the attacker to cause PHP code injection,
  directory traversal, gain sensitive information, and can cause arbitrary
  code execution inside the context of the web application.

  Impact Level: Application

  Affected Software/OS:
  Bitweaver version 2.6.0 and prior

  Fix: Upgrade to Bitweaver version 2.6.1 or later
  http://www.bitweaver.org/downloads/file/16337

  References:
  http://secunia.com/advisories/35057
  http://www.milw0rm.com/exploits/8659
  http://www.bitweaver.org/articles/121

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Bitweaver");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_bitweaver_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

bitweaverPort = get_http_port(default:80);
if(!bitweaverPort){
  exit(0);
}

bitweaverVer = get_kb_item("www/"+ bitweaverPort + "/Bitweaver");
if(bitweaverVer == NULL){
  exit(0);
}

ver = eregmatch(pattern:"^(.+) under (/.*)$", string:bitweaverVer);
dir = ver[2];

if(!safe_checks() && dir != NULL)
{
  # if short_open_tag in php.ini is off (because of "<?xml ..." preamble
  # generating a parse error with short_open_tag = on), you can now launch
  # commands:

  pocReq = http_get(item:string(dir + "/boards/boards_rss.php?version=" +
                                      "/../../../../bookoo.php \r\n\r\n"),
                                port:bitweaverPort);
  rcvRes = http_send_recv(port:bitweaverPort, data:pocReq);

  if("Set-Cookie: BWSESSION" >< rcvRes &&
      egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    pocReq = http_get(item:string(dir + "/bookoo.php.xml \r\n\r\n"),
                      port:bitweaverPort);
    rcvRes = http_send_recv(port:bitweaverPort, data:pocReq);

    if(egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes) &&
       "<title> Feed</title>" >< rcvRes)
    {
      security_hole(bitweaverPort);
      exit(0);
    }
  }
}

if(ver[1] != NULL)
{
  # Check for Bitweaver version prior to 2.6.1
  if(version_is_less(version:ver[1], test_version:"2.6.1")){
    security_hole(bitweaverPort);
  }
}
