##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bitdefender_xss_vuln.nasl 866 2009-03-17 16:32:38Z mar $
#
# BitDefender Internet Security 2009 XSS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900327);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0850");
  script_bugtraq_id(33921);
  script_name("BitDefender Internet Security 2009 XSS Vulnerability");
  desc = "

  Overview: This host is installed with BitDefender Internet Security and
  is prone to cross site scripting vulnerability.

  Vulnerability Insight:
  BitDefender Internet Security product fails to properly sanitise the input
  passed through the filename (.rar or .zip archives) of an infected executable
  before being used to output infection details.

  Impact:
  Successful exploitation will let the attacker execute arbitrary script codes
  in a local context by including a malicious HTML file placed on the local
  system.

  Impact Level: System/Application

  Affected Software/OS:
  BitDefender Internet Security version 2009 build 12.0.11.4 and prior.

  Fix: No solution or patch is available as on 19th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.bitdefender.com

  References:
  http://secunia.com/advisories/34082
  http://www.vupen.com/english/advisories/2009/0557
  http://www.securityfocus.com/archive/1/archive/1/501277/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of BitDefender Internet Security");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows");
  script_dependencies("secpod_bitdefender_prdts_detect.nasl");
  script_require_keys("BitDefender/InetSec/Ver");
  exit(0);
}


include("version_func.inc");

bitVer = get_kb_item("BitDefender/InetSec/Ver");
if(!bitVer){
  exit(0);
}

# Check for version 12.0.11.4 and prior
if(version_is_less_equal(version:bitVer, test_version:"12.0.11.4")){
  security_warning(0);
}
