###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_axon_virtual_pbx_mult_xss_vuln.nasl 5849 2009-11-24 15:48:03Z nov $
#
# Axon Virtual PBX Multiple Cross Site Scripting Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900984);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-4038");
  script_name("Axon Virtual PBX Multiple Cross Site Scripting Vulnerabilities");
  desc = "
  Overview:
  This host has Axon Virtual PBX installed and is prone to Multiple XSS
  vulnerabilities.

  Vulnerability Insight:
  The input passed into 'onok' and 'oncancel' parameters in the logon program
  is not properly sanitised before being returned to the user.

  Impact:
  Successful exploitation will let the attackers execute arbitrary HTML and
  script code in the affected user's browser session.

  Impact Level: Application

  Affected Software/OS:
  Axon Virtual PBX version 2.10 and 2.11

  Fix:
  No solution or patch is available as on 24th November,2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.nch.com.au/pbx/index.html

  References:
  http://secunia.com/advisories/37157/
  http://en.securitylab.ru/nvd/387986.php

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Axon Virtual PBX");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_axon_virtual_pbx_detect.nasl");
  script_require_keys("Axon-Virtual-PBX/Ver");
  exit(0);
}

include("http_func.inc");

axonPort = get_http_port(default:81);
if(!get_port_state(axonPort)){
  exit(0);
}

banner = get_http_banner(port:axonPort);
if(("NCH Software" >< banner) && ("Axon" >< banner))
{
  axonVer = get_kb_item("Axon-Virtual-PBX/Ver");
  # Check for Axon Virtual PBX version is 2.10 or 2.11
  if(axonVer =~ "2.1(0|1)"){
    security_warning(axonPort);
  }
}

