##############################################################################
#
#  Apple Safari for Windows Multiple Vulnerabilities July-08
#
#  Date Written: 2008/07/07
#
#  Revision: 1.2
#
#  Log:
#  Issue #0010 schandan
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900002);
 script_bugtraq_id(29412, 29413, 29835, 29835);
 script_cve_id("CVE-2008-1573", "CVE-2008-2306", "CVE-2008-2307");
 script_copyright("Copyright 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("Apple Safari for Windows Multiple Vulnerabilities July-08");
 script_summary("Check for Apple Safari version");
 desc = "
 Overview : The host is installed with Apple Safari Web Browser, which is
 prone to multiple vulnerabilities.

 Vulnerability Insight :

        The vulnerability exists due to,
        - improper handling of BMP and GIF images that can lead to disclosure of
          system memory contents.
        - handling of files that are downloaded from a website which is in
          Internet Explorer 7 Zone with the Launching applications and unsafe files set to
          Enable, or in the Internet Explorer 6 Local Intranet or Trusted sites zone causing
          safary to launch unsafe executables.
        - an error in handling JavaScript arrays that can lead to memory corruption.

        Impact : Successful exploitation by attacker could lead to exposure of
        sensitive information, system access or denying the application and allow execution of
        arbitrary code.

 Impact Level : SYSTEM

 Affected Software/OS : Apple Safari versions prior to 3.1.2 on Windows (All).

 Fix: Update safary to version 3.1.2
 http://www.apple.com/support/downloads/

 References : http://support.apple.com/kb/HT2092
              http://secunia.com/advisories/30801/
              http://secunia.com/advisories/30775/
              http://www.frsirt.com/english/advisories/2008/1882
              http://securitytracker.com/alerts/2008/Jun/1020330.html

 CVSS Score Report :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 6.5 
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl",
		     "secpod_apple_safari_detect_win_900003.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 if(!get_kb_item("SMB/WindowsVersion")){
 	exit(0);
 }

 # Grep for Apple Safari Version < 3.1.2 (3.525.21.0)
 if(egrep(pattern:"^(2\..*|3\.(52[2-4]\..*|525\.([01][0-9]|20)\..*))$",
	  string:get_kb_item("AppleSafari/Version"))){
	security_hole(0);
 }
