###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_an_image_gallery_xss_vuln.nasl 5060 2009-09-30 15:11:27Z sep $
#
# An Image Gallery Multiple Cross-Site Scripting Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901038);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3367");
  script_name("An Image Gallery Multiple Cross-Site Scripting Vulnerability");
  desc = "
  Overview: The host is running An Image Gallery and is prone to Multiple
  Cross-Site Scripting Vulnerability.

  Vulnerability Insight:
  Input passed to the 'path' parameter in 'index.php' and 'main.php' and to
  the 'show' parameter in 'main.php' is not properly sanitised before being
  returned to the user.

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary
  HTML and script code in a user's browser session in the context of an
  affected site.

  Impact Level:System/Application.

  Affected Software/OS:
  An Image Gallery version 1.0 and prior.

  Fix: No solution or patch is available as on 30th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://plohni.com/wb/content/php/Free_scripts.php

  References:
  http://secunia.com/advisories/36680

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score  : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of An Image Gallery");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

anPort = get_http_port(default:80);
if(!anPort){
  anPort = 80;
}

if(!get_port_state(anPort)){
  exit(0);
}

if(safe_checks()){
  exit(0);
}

foreach dir (make_list("/", "/image_gallery", "/gallery", "/album", cgi_dirs()))
{
  sndReq = http_get(item:string(dir + "/main.php"), port:anPort);
  rcvRes = http_send_recv(port:anPort, data:sndReq);

  if("An image gallery" >< rcvRes)
  {
    request = http_get(item:dir + "/main.php?show=<script>alert(Exploit-XSS)" +
                                  "</script>",port:anPort);
    response = http_send_recv(port:anPort, data:request);

    if("Exploit-XSS" >< response)
    {
      security_warning(anPort);
      exit(0);
    }
  }
}
