##############################################################################
#
#  Adobe PageMaker Font Structure Multiple BOF Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/30
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0411
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900168);
  script_bugtraq_id(31975);
  script_cve_id("CVE-2007-6432", "CVE-2007-5394", "CVE-2007-6021");
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family("Buffer overflow");
  script_name("Adobe PageMaker Font Structure Multiple BOF Vulnerabilities");
  script_summary("Check for vulnerable version of Adobe PageMaker");
  desc = "
  Overview: This host is installed with Adobe PageMaker and is prone to multiple
  buffer overflow vulnerability.

  The flaws are caused due to error in processing specially crafted PMD files.
  These can be exploited to cause stack-based and heap-based overflow. 

  Impact:
  Allows remote attackers to execute arbitrary code, and deny the service.

  Impact Level: Application

  Affected Software/OS:
  Adobe PageMaker versions 7.0.2 and prior on Windows (all)

  Fix: Apply patch,
  http://www.adobe.com/support/security/advisories/apsa08-10.html

  *****
  NOTE: Ignore this warning, if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/27200/
  http://www.securitytracker.com/alerts/2008/Oct/1021119.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe PageMaker 7.0";
pmVer = registry_get_sz(key:key, item:"DisplayVersion");

if(pmVer){
  # Grep for PageMaker versions 7.0.2 and prior
  if(egrep(pattern:"^([0-6](\..*)|7\.0(\.[0-2])?)$", string:pmVer)){
    security_hole(0);
  }
}
