# OpenVAS Vulnerability Test
# $Id$
# Description: This script ensure that the Sybase EAServer management console is running
#
# remote-detect-sybase-easerver-mgmt.nasl
#
# Author:
# Christian Eric Edjenguele <christian.edjenguele@owasp.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 and later,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#



if(description)
{
script_id(80005);
name = "Sybase Enterprise Application Server Management Console detection";
script_name(name);
 
 desc = "
The remote host is running the Sybase Enterprise Application Server JSP Administration Console.  
Sybase EAServer is the open application server from Sybase Inc an enterprise software and services company,
exclusively focused on managing and mobilizing information.


Solution :
It's recommended to allow connection to this host only from trusted host or networks,
or disable the service if not used.

Risk factor : None";

script_description(desc);

summary = " Ensure that the remote host is running a Sybase EAServer JSP Console";

script_summary(summary);

script_category(ACT_GATHER_INFO); 

script_copyright("Christian Eric Edjenguele <christian.edjenguele@owasp.org>");
family = "Service detection";
script_family(family);
script_dependencies("find_service.nes", "remote-detect-sybase-easerver.nasl");
script_require_ports("Services/www");
script_require_keys("SybaseEAServer/installed");
exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("openvas-https.inc");


http_servers = get_kb_list("Services/www");
soc_timeout = 10;

if(!get_kb_item("SybaseEAServer/installed"))
	exit(0);

# if the server accept clear http
if(http_server)
{

foreach port (http_servers)
{
# connect to the remote host and send the request on each port
soc = open_sock_tcp(port);
req = http_get(item:"/WebConsole/Login.jsp", port:port);
send(socket:soc, data:req, timeout:soc_timeout);

# read the reply
reply = recv(socket:soc, length:4096);

if(reply)
{
if(("<TITLE>Sybase EAServer<" >< reply || egrep(pattern:"Sybase Management Console Login", string:reply))) 
set_kb_item (name:"SybaseJSPConsole/installed", value:TRUE);
security_note(port);
}
}
}

else 
{
# Force this if the server only accept ssl connections
https_servers = get_kb_list("Services/https");

foreach port (https_servers)
r= https_req_get(port:port, request:"/WebConsole/Login.jsp" );

if( r == NULL )exit(0);
if(("<TITLE>Sybase EAServer<" >< r || egrep(pattern:"Sybase Management Console Login", string:r)))
set_kb_item (name:"SybaseJSPConsole/installed", value:TRUE);
security_note(port);
}
