# OpenVAS Vulnerability Test
# $Id$
# Description: 
# Microsoft Security Bulletin MS07-040 - Critical
# Vulnerabilities in .NET Framework Could Allow Remote Code Execution 
# NET PE Loader Vulnerability - CVE-2007-0041
# ASP.NET Null Byte Termination Vulnerability - CVE-2007-0042
# .NET JIT Compiler Vulnerability - CVE-2007-0043
#
# remote-MS07-040.nasl
#
# Author:
# Christian Eric Edjenguele <christian.edjenguele@owasp.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 and later,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#



if(description)
{
script_id(101005);
script_cve_id("CVE-2007-0041", "CVE-2007-0042", "CVE-2007-0043");
name = "Microsoft Security Bulletin MS07-040";
script_name(name);
 
desc = "
Microsoft .NET is affected by multiples criticals vulnerabilities. 
Two of these vulnerabilities could allow remote code execution on client systems with .NET Framework installed, 
and one could allow information disclosure on Web servers running ASP.NET. 



Solution :
Microsoft has released an update to correct this issue,
you can download it from the following web site:
http://www.microsoft.com/technet/security/bulletin/ms07-040.mspx



Risk factor : Critical";

script_description(desc); 

summary = ".NET Framework Multiples Criticals Vulnerabilities";

script_summary(summary);

script_category(ACT_ATTACK);

script_copyright("Christian Eric Edjenguele <christian.edjenguele@owasp.org>");
family = "Windows : Microsoft Bulletins";
script_family(family);
script_dependencies("find_service.nes", "remote-detect-MSdotNET-version.nasl");
script_require_ports("Services/www");
script_require_keys("dotNET/version", "dotNET/port");



exit(0);

}


#
# The script code starts here
#

include("revisions-lib.inc");

dotnet = get_kb_item("dotNET/version"); 
port = get_kb_item("dotNET/port");

if(!dotnet)
	exit(0);

else
{
	# Microsoft .NET Framework version < [1.0 SP3, 1.1 SP1, 2.0 SP2]
	dotnetversion['1.0'] = revcomp(a:dotnet, b:"1.0.3705.6060"); 
	dotnetversion['1.1'] = revcomp(a:dotnet, b:"1.1.4332.2407"); 
	dotnetversion['2.0'] = revcomp(a:dotnet, b:"2.0.50727.832"); 
		
	foreach version (dotnetversion)
	{

	    	if (version == -1){
		
			# report MS07-04 vulnerability
		    	report  = 'Missing MS07-040 patch, detected Microsoft .Net Framework version: ' + dotnet;
			security_hole(port:port, data:report);
		}
	}
}
