# OpenVAS Vulnerability Test
# $Id$
# Description: This script multiple remote vulnerabilities on the Leap CMS
#
# remote-Leap_CMS_multi.nasl
#
# Author:
# Christian Eric Edjenguele <christian.edjenguele@owasp.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 and later,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#



if(description)
{
script_id(101026);
name = "Leap CMS Multiple remote vulnerabilities";
script_name(name);
 
desc = "
The remote Leap CMS is affected to multiple remote vulnerabilities. 
Leap is a single file, template independant, PHP and MySQL Content Management System.

Solution :
for the sql injection vulnerability, set your php configuration to magic_quotes_gpc = off,
for other vulnerabilities, it's recommanded to download the latest stable version

Risk factor : High";

script_description(desc); 

summary = "Detect multiple remote vulnarabilities on the Leap CMS";

script_summary(summary);

script_category(ACT_GATHER_INFO);

script_copyright("Christian Eric Edjenguele <christian.edjenguele@owasp.org>");
family = "Service detection";
script_family(family);
script_dependencies("find_service.nes", "remote-detect-Leap_CMS.nasl");
script_require_ports("Services/www", 80, 8080);
script_require_keys("LeapCMS/installed","LeapCMS/version", "LeapCMS/port");


exit(0);

}

#
# The script code starts here
#

include("misc_func.inc");
include("revisions-lib.inc");

port = get_kb_item("LeapCMS/port");
version = get_kb_item("LeapCMS/version");
report = '';

if(!get_kb_item("LeapCMS/installed") || !port || !version)
	exit(0);
else {
	if(revcomp(a:version, b:"0.1.4") <= 0)
		report += "The current version " + version + " of LeapCMS is affected to multiple remote vulnerabilities";
}

if(report)
	security_note(port:port, data:report);
