###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpmyadmin_36658.nasl 5653 2009-10-20 16:54:22Z mime $
#
# phpMyAdmin Unspecified SQL Injection and Cross Site Scripting Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100307);
 script_bugtraq_id(36658);
 script_version ("1.0-$Revision: 5653 $");

 script_name("phpMyAdmin Unspecified SQL Injection and Cross Site Scripting Vulnerabilities");

desc = "Overview:
phpMyAdmin is prone to SQL-injection and cross-site scripting
vulnerabilities because it fails to sufficiently sanitize user-
supplied data.

Exploiting these issues could allow an attacker to steal cookie-
based authentication credentials, compromise the application,
access or modify data, or exploit latent vulnerabilities in the
underlying database.

Versions prior to phpMyAdmin 2.11.9.6 and 3.2.2.1 are affected.

Solution:
Vendor updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/36658
http://www.phpmyadmin.net/
http://freshmeat.net/projects/phpmyadmin/releases/306669
http://freshmeat.net/projects/phpmyadmin/releases/306667


Risk factor : Low";

 script_description(desc);
 script_summary("Determine if phpMyAdmin is prone to SQL-injection and cross-site scripting vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("secpod_phpmyadmin_detect_900129.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/phpMyAdmin")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_in_range(version: vers, test_version: "3.2", test_version2: "3.2.2")   ||
     version_in_range(version: vers, test_version: "3.1", test_version2: "3.1.1.1") ||
     version_in_range(version: vers, test_version: "3.0", test_version2: "3.0.1")   ||
     version_in_range(version: vers, test_version: "2.11", test_version2: "2.11.9.5")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
