###################################################################################
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Espen Andersson
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>  
#
#  This script is released under the GNU GPL v2
#
#################################################################################
if(description)
{
  script_id(15392);
  script_version("$Revision: 4330 $");
  script_name("PHP-Fusion homepage address XSS");
  desc = "
  Description :
  A vulnerability exists in the remote version of PHP-Fusion that may
  allow an attacker to execute arbitrary HTML and script code in the
  context of the user's browser.

  Solution:
  Apply the patch for 4.01.

  Risk factor:informational";

  script_description(desc);
  script_summary("Checks the version of the remote PHP-Fusion");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("Web application abuses");
  script_dependencie("secpod_php_fusion_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");
port = get_http_port(default:80);

if(!get_port_state(port)){
  exit(0);
}

version = get_kb_item("www/" + port + "/php-fusion");
if(!version){
  exit(0);
}

if(version_is_less_equal(version:version, test_version:"4.00")){
  security_warning(port);
}
