###############################################################################
# OpenVAS Vulnerability Test
# $Id: oracle_webLogic_server_detect.nasl 6736 2010-02-14 11:35:00Z mime $
#
# Oracle WebLogic Server Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running the Oracle WebLogic application server.

See also:
http://www.oracle.com/technology/products/weblogic/index.html

Risk factor : None";

if (description)
{
 script_id(100493);
 script_version ("1.0-$Revision: 6736 $");

 script_name("Oracle WebLogic Server Detection");
 script_description(desc);
 script_summary("Checks for the presence of Oracle WebLogic Server");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 7001);
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:7001);
if(!get_port_state(port))exit(0);


url = string("/console/login/LoginForm.jsp");
req = http_get(item:url, port:port);
buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
if( buf == NULL )continue;

if("<title>Oracle WebLogic Server Administration Console" >< buf ||
   egrep(pattern: "<TITLE>WebLogic Server.*Console Login", string: buf)) {

   vers = string("unknown");
   ### try to get version 
   version = eregmatch(string: buf, pattern: "WebLogic Server ([0-9.]+)",icase:TRUE);

   if ( !isnull(version[1]) ) {
      vers=chomp(version[1]);
   } else {
   
     version = eregmatch(string: buf, pattern: "WebLogic Server Version: ([0-9.]+)",icase:TRUE);
     
     if ( !isnull(version[1]) ) {
        vers=chomp(version[1]);
      }

   }  

   set_kb_item(name: string("www/", port, "/WebLogic_Server"), value: string(vers));

   if("unknown" >!< vers) {
     set_kb_item(name: string("cpe:/a:bea:weblogic_server:",vers), value: TRUE);
   } else {
     set_kb_item(name: string("cpe:/a:bea:weblogic_server"), value: TRUE);
   }  


   info = string("None\n\nWebLogic Server Version '");
   info += string(vers);
   info += string("' was detected on the remote host.\n\n");

   desc = ereg_replace(
       string:desc,
       pattern:"None$",
       replace:info
   );

      if(report_verbosity > 0) {
        security_note(port:port,data:desc);
      }
      exit(0);

}
exit(0);

