#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 01 $

if(description)
{

 script_id(90029);
 script_version ("$Revision: 01 $");
 script_cve_id("CVE-2008-2152");
 name = "OpenOffice.org <= 2.4.1 vulnerability (Lin)";
 script_name(name);

 desc = "The remote host is probably affected by the vulnerabilities described in
CVE-2008-2152 or CVE-2008-3282 on 64-bit platform's

OpenOffice.org <= 2.4.1 vulnerability

Impact

   CVE-2008-2152
     Integer overflow in the rtl_allocateMemory function in
     sal/rtl/source/alloc_global.c in OpenOffice.org (OOo)
     2.0 through 2.4 allows remote attackers to execute
     arbitrary code via a crafted file that triggers a
     heap-based buffer overflow. 
   CVE-2008-3282
     Integer overflow in the rtl_allocateMemory function
     in sal/rtl/source/alloc_global.c in the memory allocator
     in OpenOffice.org (OOo) 2.4.1, on 64-bit platforms, allows
     remote attackers to cause a denial of service (application
     crash) or possibly execute arbitrary code via a crafted
     document, related to a 'numeric truncation error,' a
     different vulnerability than CVE-2008-2152. 
 
References:
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2152
    http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-3282

Solution:
    All OpenOffice.org users should upgrade to the latest version:


Risk factor : High
";

 script_description(desc);
 summary = "Determines OpenOffice.org <= 2.4.1 vulnerability";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is under GPLv2");
 family = "General";
 script_family(family);
 script_dependencies("ssh_authorization.nasl");
 exit(0);
}

#
# The code starts here
#

include("ssh_func.inc");
include("version_func.inc");

local_var ver, sec_hole, sec_proto, garg, file_name, arg, r, i, t, l, p;

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

sec_hole = 0;
sec_proto = "OpenOffice.org";
test_version = "2.4.9310";
ver = NULL;
r = NULL;

  l = find_file(file_name:"soffice.bin", sock:sock);
  if( isnull(l) ) {
    l = find_file(file_path:"/usr/lib/", file_name:"soffice.bin", sock:sock);
    if( isnull(l) ) {    
      l = find_file(file_path:"/usr/lib64/", file_name:"soffice.bin", sock:sock);
    }
  }
  if( ! isnull(l) ) {
    i = 0;
    foreach t (l) {
      if( "soffice.bin" >< t ) {
        p = chomp(ereg_replace(string:t, pattern:"soffice.bin", replace:""));
        if( !isnull(find_file(file_path:p, file_name:"versionrc", sock:sock)) ) {
          r[i++] =  p + "versionrc";
        }
      }
    }
    foreach file_name (r) {
      file_name = chomp(file_name);
      if(islocalhost()) { 
        arg = file_name;
      } else {
        arg = raw_string(0x22)+file_name+raw_string(0x22);
      }
      ver = get_bin_version(full_prog_name:"cat", version_argv:arg, ver_pattern:".+");
      if( ! isnull(ver) && !((ver[0] =~ "Vendor=Debian") && (ver[0] !~ "Ubuntu")) ) {
        version = ereg_replace(pattern:".+OOOBaseVersion=", string: ver[0], replace: "")+".";
        version = eregmatch(pattern:"([0-9]\.)+[0-9]+", string: version);
        build = ereg_replace(pattern:".+ProductBuildid=", string: ver[0], replace: "");
        build = eregmatch(pattern:"^[0-9]+", string: build);
        ver = version[0]+"."+build[0];
        set_kb_item(name: "OpenOffice.org/Build", value: ver);
        if( "/lib64" >< t ) {
          test_version = "2.4.9311";
        } else {
          test_version = "2.4.9310";          
        }
        if( version_is_less(version:ver, test_version:test_version) ) {
          if(sec_hole == 0) {
            security_warning(port:0, proto:sec_proto);
            sec_hole = 1;
          }
          security_warning(port:0, proto:sec_proto, data:string("\nFound : ") + 
                       (ereg_replace(string:file_name, pattern:"versionrc", replace:"soffice.bin")) +
                       " Build : " + ver + string("\n"));
        }  
      }
    }
  }
exit(0);
