###############################################################################
# OpenVAS Vulnerability Test
# $Id: ntop_detect.nasl 6984 2010-03-17 12:20:23Z mime $
#
# Ntop Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.

desc = "

Overview:
This host is running Ntop, a a network traffic probe that shows the
network usage, similar to what the popular top Unix command does.

See also:
http://www.ntop.org

Risk factor : None";

if (description)
{
 script_id(100256);
 script_version ("1.0");

 script_name("Ntop Detection");
 script_description(desc);
 script_summary("Checks for the presence of Ntop");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/www", 3000);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("http_func.inc");
include("global_settings.inc");

port = get_http_port(default:3000);
if(!get_port_state(port))exit(0);

buf = get_http_banner(port:port);
if( buf == NULL )exit(0);

if(egrep(pattern:"Server: ntop" , string: buf, icase: TRUE))
 {

    vers = string("unknown");
    ### try to get version 
    version = eregmatch(string: buf, pattern: "Server: ntop/([0-9.]+)",icase:TRUE);

    if ( !isnull(version[1]) ) {
       vers=chomp(version[1]);
    }

    set_kb_item(name: string("www/", port, "/ntop"), value: string(vers));
    set_kb_item(name: string("/ntop/installed"), value: TRUE);


    info = string("None\n\nNtop Version '");
    info += string(vers);
    info += string("' was detected on the remote host\n\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }

exit(0);

