#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# This script is released under the GNU GPLv2

if(description)
{
 script_id(14378);
 script_version ("$Revision: 4330 $");
 name = "NetAsq identification";
 
 script_name(name);
 
 desc = "

It's very likely that this remote host is a NetAsq IPS-Firewalls
with port TCP/1300 open to allow Firewall Manager tool to
remotely configure it.

Letting attackers know that you are using a NetAsq 
will help them to focus their attack or will 
make them change their strategy. 

You should not let them know such information.

Solution : do not allow any connection on the
firewall itself, except from trusted network.

See also : http://www.netasq.com
Risk factor : Low";



 script_description(desc);
 
 summary = "Determines if the remote host is a NetAsq";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 family = "Firewalls";
 script_family(family);
 script_require_ports(1300);
 exit(0);
}

#
# The script code starts here
#

port=1300;

if (get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(!soc)exit(0);
 req=string("OPENVAS\r\n");
 send(socket:soc, data:req);
 r=recv(socket:soc,length:512);
 
 if (ereg(pattern:"^200 code=[0-9]+ msg=.*", string:r))
 {
 	req=string("QUIT\r\n");
 	send(socket:soc, data:req);
 	r=recv(socket:soc,length:512);
	if (ereg(pattern:"^103 code=[0-9]+ msg=.*\.\.\.", string:r))
	{
		security_warning(port);
	}
 }
 close(soc);
}
exit(0);
