###############################################################################
# OpenVAS Vulnerability Test
# $Id: mysql_multiple_vuln.nasl 5915 2009-11-20 11:35:38Z mime $
#
# MySQL multiple Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100356);
 script_bugtraq_id(37075,37076);
 script_version ("1.0-$Revision: 5915 $");

 script_name("MySQL multiple Vulnerabilities");

desc = "Overview:
MySQL is prone to a security-bypass vulnerability and to to a local
privilege-escalation vulnerability.

An attacker can exploit the security-bypass issue to bypass certain
security restrictions and obtain sensitive information that may lead
to further attacks.

Local attackers can exploit the local privilege-escalation issue to
gain elevated privileges on the affected computer.

Versions prior to MySQL 5.1.41 are vulnerable.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37076
http://www.securityfocus.com/bid/37075
http://dev.mysql.com/doc/refman/5.1/en/news-5-1-41.html
http://www.mysql.com/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if MySQL is prone to multiple Vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Databases");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("mysql_version.nasl");
 script_require_ports("Services/mysql", 3306);
 exit(0);
}

include("version_func.inc");
include("misc_func.inc");

port = get_kb_item("Services/mysql");
if(!port)exit(0);
if(!get_tcp_port_state(port))exit(0);

if(!ver = get_mysql_version(port:port))exit(0);
ver = eregmatch(pattern:"[0-9.]+", string: ver);

if(isnull(ver[0]))exit(0);

if(ver[0] =~ "5\.") {
  if(version_is_less(version:ver[0], test_version:"5.1.41") ) {
    security_warning(port:port);
    exit(0);
  }
}

exit(0);
