#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
#
# This script is released under the GNU GPLv2
#
# $Revision: 01 $

if(description)
{

 script_id(90014);
 script_version ("$Revision: 01 $");
 script_cve_id("CVE-2008-1238","CVE-2008-1240","CVE-2008-1241");
 name = "Mozilla Firefox, Thunderbird, Seamonkey. Several vulnerabilitys (Lin)";
 script_name(name);

 desc = "The remote host is probable affected by the vulnerabilitys described in 
CVE-2008-0416, CVE-2007-4879, CVE-2008-1195, CVE-2008-1233,
CVE-2008-1234, CVE-2008-1235, CVE-2008-1236, CVE-2008-1237,
CVE-2008-1238, CVE-2008-1240, CVE-2008-1241 and more.


Impact
     Mozilla contributors moz_bug_r_a4, Boris Zbarsky, 
     and Johnny Stenback reported a series of vulnerabilities 
     which allow scripts from page content to run with elevated
     privileges. moz_bug_r_a4 demonstrated additional variants
     of MFSA 2007-25 and MFSA2007-35 (arbitrary code execution
     through XPCNativeWrapper pollution). Additional 
     vulnerabilities reported separately by Boris Zbarsky, 
     Johnny Stenback, and moz_bug_r_a4 showed that the browser
     could be forced to run JavaScript code using the wrong 
     principal leading to universal XSS and arbitrary code execution.
     And more...


References:
    http://www.mozilla.org/security/announce/2008/mfsa2008-14.html
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0412
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0416
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1238
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1240
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1241
    .
    .
    .

Solution:
    All Users should upgrade to the latest versions of Firefox, Thunderbird or Seamonkey.


Risk factor : High";

 script_description(desc);
 summary = "Mozilla Firefox, Thunderbird, Seamonkey. Several vulnerabilitys";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is under GPLv2");
 family = "General";
 script_family(family);
 script_dependencies("ssh_authorization.nasl");
 exit(0);
}

#
# The code starts here
#


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

r = find_bin(prog_name:"firefox", sock:sock);
foreach binary_name (r) {
  binary_name = chomp(binary_name);
  ver = get_bin_version(full_prog_name:binary_name, version_argv:"--version", ver_pattern:"([0-9\.]+)");
  if(ver != NULL) {
    if(version_is_less(version:ver[0], test_version:"2.0.0.14") ) {
      security_hole(port:0, proto:"Mozilla");
      report = string("\nFound : ") + binary_name + "  Version : " + ver[max_index(ver)-1] + string("\n");
      security_hole(port:0, proto:"Mozilla", data:report);
    } 
  }
}
r = find_bin(prog_name:"thunderbird", sock:sock);
foreach binary_name (r) {
  binary_name = chomp(binary_name);
  ver = get_bin_version(full_prog_name:binary_name, version_argv:"--version", ver_pattern:"([0-9\.]+)");
  if(ver != NULL) {
    if(version_is_less(version:ver[0], test_version:"2.0.0.14") ) {
      security_hole(port:0, proto:"Mozilla");
      report = string("\nFound : ") + binary_name + "  Version : " + ver[max_index(ver)-1] + string("\n");
      security_hole(port:0, proto:"Mozilla", data:report);
    } 
  }
}
r = find_bin(prog_name:"seamonkey", sock:sock);
foreach binary_name (r) {
  binary_name = chomp(binary_name);
  ver = get_bin_version(full_prog_name:binary_name, version_argv:"--version", ver_pattern:"([0-9\.]+)");
  if(ver != NULL) {
    if(version_is_less(version:ver[0], test_version:"1.1.9") ) {
      security_hole(port:0, proto:"Mozilla");
      report = string("\nFound : ") + binary_name + "  Version : " + ver[max_index(ver)-1] + string("\n");
      security_hole(port:0, proto:"Mozilla", data:report);
    } 
  }
}

exit(0);
