##################################################################################
#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  Released under the GNU GPL v2
#  Ref: Mindwarper <mindwarper at hush.com>
#
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>
#
#
#################################################################################
if (description)
{
  script_id(16315);
  script_cve_id("CVE-2003-1204");
  script_bugtraq_id(6571, 6572);
  script_version ("$Revision: 4329 $");
  script_name("Mambo Site Server XSS and remote arbitrary code execution");
  desc = "
  An attacker may use the installed version of Mambo Site Server to
  perform a cross site scripting attack on this host or execute arbitrary
  code through the gallery image uploader under the administrator
  directory. 
  See also : http://www.securityfocus.com/archive/1/306206
  Solution: Upgrade to the latest version of this software.
  Risk factor : Medium";

  script_description(desc);
  script_summary("Determine if Mambo Site Server is vulnerable to xss attack and remote flaw");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_copyright("This script is Copyright (C) 2005 David Maciejak");
  script_dependencie("mambo_detect.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port)){
  exit(0);
}

version=get_kb_item(string("www/", port, "/mambo_mos"));
if(!version){
   exit(0);
}

matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$");
if(!matches){
  exit(0);
}

 dir = matches[2];
 url = string(dir, "/themes/mambosimple.php?detection=detected&sitename=</title><script>foo</script>");
 req = http_get(item:url, port:port);
 resp = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( !resp){
   exit(0);
 }

if('<a href="?detection=detected&sitename=</title><script>foo</script>' >< resp )
    security_warning(port);

