###############################################################################
# OpenVAS Vulnerability Test
# $Id: joomla_detect.nasl 5776 2009-11-02 12:02:45Z mime $
#
# joomla Detection
#
# Authors:
# Angelo Compagnucci
#
# Copyright:
# Copyright (c) 2009 Angelo Compagnucci
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "

Overview:
This host is running Joomla! a widely installed Open Source cms solution.

See also:
http://www.joomla.org

Risk factor : None";

if (description)
{
    script_id(100330);
    script_version ("1.0");

    script_name("Joomla! Detection");  

    script_description(desc);
    script_summary("Checks for the presence of Joomla!");
    script_category(ACT_GATHER_INFO);
    script_family("Service detection");
    script_copyright("This script is Copyright (C) 2009 Angelo Compagnucci");
    script_dependencie("find_service.nes", "http_version.nasl");
    script_require_ports("Services/www", 80);
    script_exclude_keys("Settings/disable_cgi_scanning");
    exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dirs = make_list("", "/cms", "/joomla", cgi_dirs());

foreach dir (dirs) {

    url = string(dir, "/index.php"); 
    req = http_get(item:url, port:port);
    buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
    if( buf == NULL )continue;

    if( 
            egrep(pattern: '.*content="joomla.*', string: buf) ||
            egrep(pattern: '.*content="Joomla.*', string: buf) ||
            egrep(pattern: '.*href="/administrator/templates.*', string: buf) ||
            egrep(pattern: '.*src="/media/system/js.*', string: buf) ||
            egrep(pattern: '.*src="/templates/system.*', string: buf)
            )
    { 
        if(strlen(dir)>0) {
            install=dir;
        } else {
            install=string("/");
        }

    } else {

        url = string(dir, "/.htaccess");
        req = http_get(item:url, port:port);
        buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
        if( buf == NULL )continue;

        if(
                egrep(pattern: ".*# @package Joomla.*", string: buf)
                )
        {
            if(strlen(dir)>0) {
                install=dir;
            } else {
                install=string("/");
            }		

        } else {

            url = string(dir, "/templates/system/css/editor.css");
            req = http_get(item:url, port:port);
            buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
            if( buf == NULL )continue;

            if(
                    egrep(pattern: ".*JOOMLA.*", string: buf)	
                    )
            {
                if(strlen(dir)>0) {     
                    install=dir;
                } else {
                    install=string("/");
                }
                
            } else {

                url = string(dir, "/includes/js/mambojavascript.js");
                req = http_get(item:url, port:port);
                buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
                if( buf == NULL )continue;

                if(
                        egrep(pattern: ".*@package Joomla.*", string: buf)
                        )
                {
                    if(strlen(dir)>0) {
                        install=dir;
                    } else {
                        install=string("/");	
                    }
                }
            }
        }
    }

    if(install) {
        vers = string("unknown");
        lang = string("en-GB");
        
        url = string(dir, "/administrator/");
        req = http_get(item:url, port:port);
        buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
        language = eregmatch(string: buf, pattern: 'lang="(..-..)"');
        if ( !isnull(language[1]) ) {
            lang = substr(language[1],0,1) + "-" + toupper(substr(language[1],3));
        }
        
        url = string(dir, "/administrator/language/"+lang+"/"+lang+".xml");
        req = http_get(item:url, port:port);
        buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
        version = eregmatch(string: buf, pattern: ".*<version>(.*)</version>.*");
        if ( !isnull(version[1]) ) {
            vers=version[1];
        } else {
            
            url = string(dir, "/");
            req = http_get(item:url, port:port);
            buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
            language = eregmatch(string: buf, pattern: 'lang="(..-..)"');
            if ( !isnull(language[1]) ) {
                lang = substr(language[1],0,1) + "-" + toupper(substr(language[1],3));
            }
            
            url = string(dir, "/language/"+lang+"/"+lang+".xml");
            req = http_get(item:url, port:port);
            buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
            version = eregmatch(string: buf, pattern: ".*<version>(.*)</version>.*");
            if ( !isnull(version[1]) ) {
                vers=version[1];
            } else {

                url = string(dir, "/components/com_user/user.xml");
                req = http_get(item:url, port:port);
                buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
                version = eregmatch(string: buf, pattern: ".*<version>(.*)</version>.*");

                if ( !isnull(version[1]) ) {
                    vers=version[1];
                } else {

                    url = string(dir, "/modules/mod_login/mod_login.xml");
                    req = http_get(item:url, port:port);
                    buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
                    version = eregmatch(string: buf, pattern: ".*<version>(.*)</version>.*");
                    
                    if ( !isnull(version[1]) ) {
                        vers=version[1];
                    }
                }
            }
        }

            set_kb_item(name: string("www/", port, "/joomla"), value: string(vers," under ",install));
            info = string("None\n\nJoomla Version (");
            info += string(vers);
            info += string(") with lang(");
            info += string(lang);
            info += string(") was detected on the remote host in the following directory(s):\n\n");
            info += string(install, "\n"); 

            desc = ereg_replace(
            string:desc,
            pattern:"None$",
            replace:info
            ); 
            
            if(report_verbosity > 0) {
                security_note(port:port,data:desc);
            }
        exit(0);
    }
}
exit(0);
