###############################################################################
# OpenVAS Vulnerability Test
# $Id: invision_power_board_37208.nasl 6098 2009-12-08 21:02:24Z mime $
#
# Invision Power Board Local File Include and SQL Injection Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100381);
 script_bugtraq_id(37208);
 script_version ("1.0-$Revision: 6098 $");

 script_name("Invision Power Board Local File Include and SQL Injection Vulnerabilities");

desc = "Overview:
Invision Power Board is prone to a local file-include vulnerability
and multiple SQL-injection vulnerabilities because it fails to
properly sanitize user-supplied input.

An attacker can exploit the local file-include vulnerability using directory-
traversal strings to view and execute arbitrary local files within the
context of the webserver process. Information harvested may aid in
further attacks.

The attacker can exploit the SQL-injection vulnerabilities to
compromise the application, access or modify data, or exploit latent
vulnerabilities in the underlying database.

Invision Power Board 3.0.4 and 2.3.6 are vulnerable; other versions
may also be affected.

References:
http://www.securityfocus.com/bid/37208
http://www.invisionpower.com/community/board/index.html
http://www.securityfocus.com/archive/1/508207

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Invision Power Board version is 3.0.4 or 2.3.6");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("invision_power_board_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/invision_power_board")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "3.0.4") ||
     version_is_equal(version: vers, test_version: "2.3.6")
     ) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
