#
# This script was written by Vincent Renardias <vincent@strongholdnet.com>
#
# License : GPLv2
#

if(description)
{
 script_id(11414);
 script_version ("$Revision: 4329 $");
 
 name = "IMAP Banner";
 
 script_name(name);
 
 desc = "
Displays the imap4 service banner.

Risk factor: None";

 script_copyright("This script is Copyright (C) 2003 StrongHoldNet");

 script_description(desc);
 summary = "displays the imap4 banner";
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 family = "General";
 script_family(family); 

 script_dependencie("find_service.nes");
 script_require_ports("Services/imap", 143);
 exit(0);
}


port = get_kb_item("Services/imap");

if(!port) port = 143;

banner = get_kb_item(string("imap/banner/", port));

if(banner)
{
 if (!ereg(pattern:"\* OK", string:banner)) exit(0);
 report = string("The remote imap server banner is :\n",banner,
 "\nVersions and types should be omitted where possible.\nChange the imap banner to something generic.");
 security_note(port:port, data:report);
}

