###############################################################################
# OpenVAS Vulnerability Test
# $Id: hp_power_manager_detect.nasl 6470 2010-01-20 18:30:24Z mime $
#
# HP Power Manager Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running HP Power Manager, an UPS management and
monitoring utility.

See also:
http://h18000.www1.hp.com/products/servers/proliantstorage/power-protection/software/power-manager/index.html

Risk factor : None";

if (description)
{
 script_id(100456);
 script_version ("1.0-$Revision: 6470 $");

 script_name("HP Power Manager Detection");
 script_description(desc);
 script_summary("Checks for the presence of HP Power Manager");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

banner = get_http_banner(port:port);
if("GoAhead-Webs" >!< banner)exit(0);

url = string("/CPage/About_English.asp");
req = http_get(item:url, port:port);
buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
if( buf == NULL )continue;

if(egrep(pattern: "About HP Power Manager", string: buf, icase: TRUE))
{

    vers = string("unknown");
    ### try to get version 
    version = eregmatch(string: buf, pattern: "HP Power Manager ([0-9.]+)[ ]*([(Build 0-9)]*)",icase:TRUE);

    if(!isnull(version[1])) {
      
      if("Build" >< version[2]) {
        build = eregmatch(pattern: "\(Build ([0-9]+)\)", string: version[2]);
        vers = version[1] + "." + build[1];
      } else { 	
        vers=chomp(version[1]);
      }

     set_kb_item(name: string("cpe:/a:hp:power_manager:", vers), value: TRUE);
    
    } else {
       set_kb_item(name: string("cpe:/a:hp:power_manager"), value: TRUE);
    }  

    set_kb_item(name: string("www/", port, "/hp_power_manager"), value: string(vers));

    info = string("None\n\nHP Power Manager Version '");
    info += string(vers);
    info += string("' was detected on the remote host.\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }

exit(0);

