#
# This script was written by Mathieu Perrin <mathieu@tpfh.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10098);
 script_bugtraq_id(776);
 script_version ("$Revision: 4328 $");
 script_cve_id("CVE-1999-0237"); 
 name = "guestbook.cgi";
 script_name(name);

 desc = "The 'guestbook.cgi' is installed. This CGI has
 a well known security flaw that lets anyone execute arbitrary
 commands with the privileges of the http daemon (root or nobody).

Solution :  remove it from /cgi-bin.

Risk factor : High";




 script_description(desc);

 summary = "Checks for the presence of /cgi-bin/guestbook.cgi";
   
 script_summary(summary);

 script_category(ACT_GATHER_INFO);


 script_copyright("This script is Copyright (C) 1999 Mathieu Perrin");

 family = "Web application abuses";
 script_family(family);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 
 exit(0);
}	  
  
#
# The script code starts here
#
exit(0); # FPs
include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

if ( report_paranoia < 2 ) exit(0);

port = get_http_port(default:80);

res = is_cgi_installed_ka(item:"guestbook.cgi", port:port);
if(res)
{
 security_hole(port);
}
   
