#
# Script Written By Ferdy Riphagen 
#
# Script distributed under the GNU GPLv2 License.
#

if (description) {
 script_id(2000099); 
 script_version("$Revision: 1.0 $");

 script_cve_id("CVE-2002-1603");
 script_bugtraq_id(9239);
 script_xref(name:"OSVDB", value:"13295");

 name = "GoAhead WebServer Script Source Code Disclosure";
 script_name(name);
 desc = "
Synopsis :

A vulnerable version of GoAhead Webserver is running on the
remote host.

Description :

GoAhead Webserver is installed on the remote system.
It's an open-source webserver, which is capable of 
hosting ASP pages, and installation on multiple operating
systems. 

The version installed is vulnerable to Script Source Code
Disclosure, by adding extra characters to the URL. Possible 
characters are %00, %5C, %2F.  

See also :

http://aluigi.altervista.org/adv/goahead-adv3.txt
http://www.kb.cert.org/vuls/id/975041

Solution :

Upgrade to GoAhead WebServer 2.1.8 or a newer release.

Risk factor :

Medium / CVSS Base Score : 4 
(AV:R/AC:L/Au:NR/C:P/A:N/I:N/B:C)";
 script_description(desc);
 summary = "Checks for script source disclosure in GoAhead Webserver <= 2.1.7";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2006 Ferdy Riphagen");

 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

function GetFileExt(file) {
 ret = split(file, sep: '.');
 return ret;
}

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);

banner = get_http_banner(port:port);
if ("Server: GoAhead-Webs" >!< banner) exit(0);

# Possible default file which still could be available.
file[0] = "/treeapp.asp";

# Below options could possible create false-positives.
if (report_paranoia == 2 && (thorough_tests)) {
 file[1] = "/default.asp";

 if ("HTTP/1.0 302" && "Location:" >< banner) {
  redirect = egrep(pattern:"^Location:", string:banner);
  rfile = ereg_replace(pattern:"Location: http:\/\/+[^/]+", string:redirect, replace:"", icase:1); 
 
  # See if the file is really asp.
  ret = GetFileExt(file:rfile);
  if(!isnull(ret)) {
   if (ereg(pattern:"asp", string:ret[1], icase:1)) { 
    file[2] = chomp(rfile);
   }
  }
 }
}

for (n = 0; file[n]; n++) {
 # Server doesn't support keepalives.
 soc = http_open_socket(port);
 if (!soc) exit(0); 

 req = string("GET ", file[n], "%5C HTTP/1.1", "\r\n",
              "Host: ", get_host_name(), "\r\n\r\n");
 send(socket:soc, data:req);
 
 res = http_recv(socket:soc);
 http_close_socket(soc);
 
 if ('<% write(HTTP_AUTHORIZATION); %>' >< res ||
    ('<%' >< res && ('%>' >< res))) { 
  security_warning(port);
  exit(0);
 }
}
