###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_yabsoft_aihs_detect.nasl 6182 2009-12-15 16:25:36Z dec $
#
# YABSoft Advanced Image Hosting Script (AIHS) Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801091);
  script_version("Revision: 1.0 ");
  script_name("YABSoft Advanced Image Hosting Script (AIHS) Version Detection");
  desc = "
  Overview: This script finds the version of running Advanced Image Hosting
  Script (AIHS) and saves the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("YABSoft AIHS Version Detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

aihsPort = get_http_port(default:80);
if(!aihsPort){
  exit(0);
}

foreach path (make_list("/", "/aihs", "/gallery", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:aihsPort);
  rcvRes = http_send_recv(port:aihsPort, data:sndReq);

  if("yabsoft" >< rcvRes && "AIH" >< rcvRes)
  {
    aihsVer = eregmatch(pattern:"AIH v([0-9.]+)" , string:rcvRes);
    if(aihsVer[1] != NULL){
      set_kb_item(name:"www/" + aihsPort + "/YABSoft/AIHS",
                  value:aihsVer[1] + " under " + path);
    }
  }
}
