###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_xerver_http_server_xss_vuln.nasl 5185 2009-10-20 16:18:34Z oct $
#
# Xerver HTTP Server Cross Site Scripting Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801015);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3562");
  script_bugtraq_id(36457);
  script_name("Xerver HTTP Server Cross Site Scripting Vulnerability");
  desc = "
  Overview:
  This host is running Xerver HTTP Server and is prone to Cross Site Scripting
  vulnerability

  Vulnerability Insight:
  The flaw is due to improper sanitization of user supplied input passed via
  'currentPath' parameter (when 'action' is set to 'chooseDirectory') to the
  administrative interface.

  Impact:
  Successful exploitation will allow attackers to execute arbitrary HTML
  and script code in a user's browser session in context of an affected site.

  Impact Level: Application

  Affected Software/OS:
  Xerver version 4.32 and prior on all platforms.

  Fix:
  No solution or patch is available as on 20th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For more info refer, http://www.javascript.nu/xerver/

  References:
  http://secunia.com/advisories/36681
  http://www.milw0rm.com/exploits/9718

  CVSS Score:
    CVSS Base Score       : 2.6 (AV:N/AC:H/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score   : 2.3
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for XSS attack in Xerver");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_xerver_http_server_detect.nasl");
  script_require_ports("Services/www", 32123);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

foreach xerPort (make_list(32123, 80))
{
  if(get_port_state(xerPort))
  {
    xerVer = get_kb_item("www/" + xerPort + "/Xerver");
    if(!isnull(xerVer)){
     break;
    }
  }
}

if(isnull(xerVer)){
  exit(0);
}

xerPort = 32123;

if(!safe_checks())
{
  # XSS attempts
  request = http_get(item:string("/action=chooseDirectory&currentPath=''>><script>" +
                                 "alert('XSS-By-Stack')</script>"), port:xerPort);
  response = http_send_recv(port:xerPort, data:request);
  if("XSS-By-Stack" >< response)
  {
    security_warning(xerPort);
    exit(0);
  }
}

if(version_is_less_equal(version:xerVer, test_version:"4.32")){
  security_warning(xerPort);
}
