###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_xerver_detect.nasl 5185 2009-10-20 12:25:24Z oct $
#
# Xerver Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801017);
  script_version("Revision: 1.0 ");
  script_name("Xerver Version Detection");
  desc = "
  Overview : This script finds the running Xerver Version and saves the
  result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_summary("Set version of Xerver in KB");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80, 32123);
  exit(0);
}


include("http_func.inc");

foreach port(make_list(32123, 80))
{
  if(get_port_state(port))
  {
    banner = get_http_banner(port:port);
    if(banner)
    {
      xerVer = eregmatch(pattern:"Server: Xerver/([0-9.]+)",string:banner);
      if(xerVer[1] != NULL){
        set_kb_item(name:"www/" + port + "/Xerver", value:xerVer[1]);
      }
    }
  }
}
