###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_xemacs_mult_bof_vuln_win.nasl 3824 2009-08-07 10:22:41Z aug $
#
# XEmacs Multiple Buffer Overflow Vulnerabilities (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800927);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2688");
  script_bugtraq_id(35473);
  script_name("XEmacs Multiple Buffer Overflow Vulnerabilities (Win)");
  desc = "

  Overview: The host is installed with XEmacs and is prone to multiple
  Buffer Overflow vulnerabilities.

  Vulnerability Insight:
  Error exists when 'tiff_instantiate' function processing a crafted TIFF file,
  'png_instantiate' function processing a crafted PNG file, 'jpeg_instantiate'
  function processing a crafted JPEG file in the glyphs-eimage.c script that
  can be exploited to cause a heap-based buffer overflow.

  Impact:
  Attackers can exploit this issue to execute arbitrary code in the context of
  affected application, and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  XEmacs version 21.4.22 and prior on Windows.

  Fix: No solution or patch is available as on 07th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://xemacs.org/

  References:
  http://secunia.com/advisories/35348
  http://www.vupen.com/english/advisories/2009/1666

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.5
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of XEmacs");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_xemacs_detect_win.nasl");
  script_require_keys("XEmacs/Win/Ver");
  exit(0);
}


include("version_func.inc");

xemacsVer = get_kb_item("XEmacs/Win/Ver");

if(xemacsVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:xemacsVer, test_version:"21.4.22")){
  security_hole(0);
}
