###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wireshark_mult_vuln_oct08_lin.nasl 376 2008-10-23 13:09:00Z oct $
#
# Wireshark Multiple Vulnerabilities - Oct08 (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800041);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4680", "CVE-2008-4681", "CVE-2008-4682",
                "CVE-2008-4683", "CVE-2008-4684", "CVE-2008-4685");
  script_bugtraq_id(31838);
  script_name("Wireshark Multiple Vulnerabilities - Oct08 (Linux)");
  desc = "

  Overview: The Remote host is installed with Wireshark, and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  The multiple flaws are due to,
  a. an error within the Bluetooth ACL dissector, PRP or MATE post dissector.
     Versions 0.99.7 through 1.0.3 are affected by this vulnerability.
  b. an error within the Q.931 dissector. Versions 0.10.3 through 1.0.3
     are affected by this vulnerability.
  c. an uninitialized data structures within the Bluetooth RFCOMM and USB
     Request Block (URB) dissector. Versions 0.99.7 through 1.0.3 are
     affected by this vulnerability.

  Impact:
  Successful attacks may cause the application to crash via specially
  crafted packets.

  Impact Level: Application

  Affected Software/OS:
  Wireshark versions prior to 1.0.4 on Linux

  Fix: Upgrade to Wireshark 1.0.4
  http://www.wireshark.org/download.html

  References:
  http://www.wireshark.org/security/wnpa-sec-2008-06.html

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 5.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_lin.nasl");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Linux/Ver");
if(!sharkVer){
  exit(0);
}

if(version_in_range(version:sharkVer, test_version:"0.99.2",
                    test_version2:"1.0.3")){
  security_hole(0);
}
