###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wireshark_mult_bof_vuln_lin.nasl 7103 2010-02-05 12:33:29 feb $
#
# Wireshark Multiple Buffer Overflow Vulnerabilities (Linux)
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800289);
  script_version("$Revision: 6681 $: 1.0");
  script_cve_id("CVE-2010-0304");
  script_bugtraq_id(37985);
  script_name("Wireshark Multiple Buffer Overflow Vulnerabilities (Linux)");
  desc = "
  Overview: This host is installed with Wireshark and is prone to multiple Buffer
  Overflow vulnerabilities.

  Vulnerability Insight:
  The flaws are caused by buffer overflow errors in the LWRES dissector when
  processing malformed data or packets.

  Impact:
  Successful exploitation allows attackers to crash an affected application or
  potentially execute arbitrary code.

  Impact Level: Application.

  Affected Software/OS:
  Wireshark version 1.2.0 to 1.2.5 and 0.9.15 to 1.0.10

  Fix: Upgrade to Wireshark 1.2.6 or 1.0.11
  For Updates Refer, http://www.wireshark.org/download.html

  References:
  http://xforce.iss.net/xforce/xfdb/55951
  http://www.securityfocus.com/bid/37985/info
  http://www.vupen.com/english/advisories/2010/0239

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_dependencies("gb_wireshark_detect_lin.nasl");
  script_family("Buffer overflow");
  script_require_keys("Wireshark/Linux/Ver");
  exit(0);
}


include("version_func.inc");

wireVer = get_kb_item("Wireshark/Linux/Ver");
if(!wireVer){
  exit(0);
}

if(version_in_range(version:wireVer, test_version:"1.2.0", test_version2:"1.2.5") ||
   version_in_range(version:wireVer, test_version:"0.9.15", test_version2:"1.0.10")){
  security_hole(0);
}
