###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wireshark_detect_win.nasl 376 2008-10-23 09:22:01Z oct $
#
# Wireshark Version Detection (Windows)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800038);
  script_version("Revision: 1.0 ");
  script_name("Wireshark Version Detection (Windows)");
  desc = "
  Overview: This script finds the Wireshark installed version on Windows
  and saves the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the Version of Wireshark in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

wiresharkVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                   "\Uninstall\Wireshark", item:"DisplayVersion");
if(wiresharkVer){
  set_kb_item(name:"Wireshark/Win/Ver", value:wiresharkVer);
}
