###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vmware_tools_local_prv_esc_vuln_win.nasl 279 2008-09-24 12:38:09Z sep $
#
# VMware Tools Local Privilege Escalation Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800004);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2007-5671");
  script_xref(name:"CB-A", value:"08-0093");
  script_name("VMware Tools Local Privilege Escalation Vulnerability (Win)");
  desc = "

  Overview : The host is installed with VMWare product(s) that are vulnerable
  to local privilege escalation vulnerability.

  Vulnerability Insight:
  An input validation error is present in the Windows-based VMware HGFS.sys
  driver. Exploitation of this flaw might result in arbitrary code execution
  on the guest system by an unprivileged guest user. The HGFS.sys driver is
  present in the guest operating system if the VMware Tools package is loaded
  on Windows based Guest OS.

  Impact: Successful exploitation could result in guest OS users to modify
  arbitrary memory locations in guest kernel memory and gain privileges.
  
  Impact Level : System

  Affected Software/OS :
  VMware ACE 1.x - 1.0.5 build 79846 on Windows
  VMware Player 1.x - before 1.0.6 build 80404 on Windows
  VMware Server 1.x - before 1.0.5 build 80187 on Windows
  VMware Workstation 5.x - before 5.5.6 build 80404 on Windows

  Fix:
  Upgrade VMware Product(s) to below version,
  VMware ACE 1.0.5 build 79846 or later
  www.vmware.com/download/ace/

  VMware Player 1.0.6 build 80404 or later
  www.vmware.com/download/player/

  VMware Server 1.0.5 build 80187 or later
  www.vmware.com/download/server/

  VMware Workstation 5.5.6 build 80404 or later
  www.vmware.com/download/ws/

  References : http://secunia.com/advisories/30556
  http://www.vmware.com/security/advisories/VMSA-2008-0009.html

  CVSS Score :
    CVSS Base Score     : 4.1 (AV:L/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 3.0
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of VMware Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Privilege escalation");
  script_dependencies("gb_vmware_prdts_detect_win.nasl");
  exit(0);
}


if(!get_kb_item("VMware/Win/Installed")){ # Is VMWare installed?
  exit(0);
}

# VMware ACE
vmaceVer = get_kb_item("VMware/ACE/Win/Ver");
if(!vmaceVer){
  vmaceVer = get_kb_item("VMware/ACE\Dormant/Win/Ver");
}

if(vmaceVer)
{
  if(ereg(pattern:"^1\.0(\.[0-4])?$", string:vmaceVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware Player
vmplayerVer = get_kb_item("VMware/Player/Win/Ver");
if(vmplayerVer)
{
  if(ereg(pattern:"^1\.0\.[0-5]($|\..*)", string:vmplayerVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware Server
vmserverVer = get_kb_item("VMware/Server/Win/Ver");
if(vmserverVer)
{
  if(ereg(pattern:"^1\.0(\.[0-4])?$", string:vmserverVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware Workstation
vmworkstnVer = get_kb_item("VMware/Workstation/Win/Ver");
if(vmworkstnVer)
{
  if(ereg(pattern:"^5\.([0-4](\..*)?|5(\.[0-5])?)$", string:vmworkstnVer)){
    security_warning(0);
  }
}
